import numpy as np
import matplotlib.pyplot as plt
import schemas

def f(x):
    return -x

x0 = 2.
def sol_exacte(t):
    return 2 * np.exp(-t)


T = 5.


tN = np.array([50, 75, 100, 125, 150, 175, 200])

Err = np.empty((6, tN.size))
for i in range(tN.size):
    N = tN[i]
    t = np.linspace(0, T, N+1)
    Xex = sol_exacte(t)
    
    X1 = schemas.EulerExpl(x0, N, T, f)
    Err[0, i] = np.amax(np.abs(Xex - X1))

    X2 = schemas.EulerImpl(x0, N, T, f)
    Err[1, i] = np.amax(np.abs(Xex - X2))

    X3= schemas.CN(x0,N,T,f)
    Err[2,i] = np.amax(np.abs(Xex-X3))

    X4 = schemas.RK2(x0, N, T, f)
    Err[3, i] = np.amax(np.abs(Xex - X4))
    
    X5 = schemas.Heun(x0, N, T, f)
    Err[4, i] = np.amax(np.abs(Xex - X5))
    
    X6 = schemas.RK4(x0, N, T, f)
    Err[5, i] = np.amax(np.abs(Xex - X6))
    


print("Ordre Euler explicite:", -np.polyfit(np.log(tN), np.log(Err[0, :]), 1)[0])
print("Ordre Euler implicite:", -np.polyfit(np.log(tN), np.log(Err[1, :]), 1)[0])
print("Ordre Crank-Nicolson:", -np.polyfit(np.log(tN), np.log(Err[2, :]), 1)[0])
print("Ordre RK2:", -np.polyfit(np.log(tN), np.log(Err[3, :]), 1)[0])
print("Ordre Heun:", -np.polyfit(np.log(tN), np.log(Err[4, :]), 1)[0])
print("Ordre RK4:", -np.polyfit(np.log(tN), np.log(Err[5, :]), 1)[0])


plt.plot(np.log(tN), np.log(Err[0, :]))
plt.plot(np.log(tN), np.log(Err[1, :]))
plt.plot(np.log(tN), np.log(Err[2, :]))
plt.plot(np.log(tN), np.log(Err[3, :]))
plt.plot(np.log(tN), np.log(Err[4, :]))
plt.plot(np.log(tN), np.log(Err[5, :]))

plt.legend(['Euler explicite', 'Euler implicite', 'Crank-Nicolson', 'RK2', 'Heun', 'RK4'])
plt.title("Ordre des methodes de resolution d'EDO")
plt.savefig("convergence.png")
plt.show()

    
